/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskOraclePatch;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterSvcSetupStage
extends Stage {
    private String[] m_OCRlocation;
    private String[] m_VdiskLocation;
    private String m_existingCRSHomeLocation;
    private Version m_existingCRSHomeVersion;
    private List<String> m_nodesWithCRSRunning = new ArrayList<String>();
    private boolean m_isRollingUpgrade = false;
    private String m_osdba;
    private String m_oraInv;
    private String m_asmgrp;
    private ParamPreReqCRSInst m_param;
    private String[] m_asmDev;
    private boolean m_ASMCheck;
    private boolean m_localNodeCRSRunning = false;
    private String m_release;

    @Override
    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside ClusterSvcSetupStage:init()...");
        if (this.m_verificationMode == 1) {
            this.m_OCRlocation = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_OCRLOCATION);
            Trace.out((String)("==== ParamManager reports OCR storage locations as " + VerificationUtil.strArr2List(this.m_OCRlocation)));
            this.m_VdiskLocation = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_VOTINGDISK);
            Trace.out((String)("==== ParamManager reports Voting Disk locations as " + VerificationUtil.strArr2List(this.m_VdiskLocation)));
            this.m_existingCRSHomeLocation = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_CRSHOME);
            Trace.out((String)("==== ParamManager reports CRS Home location as: " + this.m_existingCRSHomeLocation));
            this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
            Trace.out((String)("==== ParamManager reports OSDBA as: " + this.m_osdba));
            this.m_asmgrp = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ASMGRP);
            Trace.out((String)("==== ParamManager reports ASMADMIN group as: " + this.m_asmgrp));
            this.m_oraInv = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
            Trace.out((String)("==== ParamManager reports ORAINV as: " + this.m_oraInv));
            this.m_asmDev = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_ASM_DEVICES);
            Trace.out((String)("==== ParamManager reports ASM_DEVICES as: " + this.m_asmDev));
            this.m_ASMCheck = this.m_paramMgr.checkASM();
            Trace.out((String)("==== ParamManager reports Check-ASM as " + this.m_ASMCheck));
            this.m_isRollingUpgrade = this.m_paramMgr.checkArgRolling();
            if (this.m_paramMgr.checkArgUpgrade()) {
                Trace.out((String)"setting install option to upgrade");
                VerificationUtil.setVariableValue("INSTALL_OPTION", "UPGRADE");
                this.initUpgradeData();
                String dest_ver = VerificationUtil.getVariableValue("DEST_VERSION");
                Version destVersion = new Version();
                if (VerificationUtil.isStringGood(dest_ver)) {
                    try {
                        destVersion = Version.getVersion((String)dest_ver);
                    }
                    catch (ConfigurationException e) {
                        throw new StageInitException(e.getMessage());
                    }
                }
                this.checkSetUpForUpgrade(destVersion);
            }
            this.m_param = new ParamPreReqCRSInst();
            if (this.m_paramMgr.checkArgUpgrade()) {
                String[] versionTokens;
                String currVersion = null;
                String crsHomeV = VerificationUtil.getVariableValue("oracle_install_crs_configuredCRSHome");
                String destVersion = VerificationUtil.getVariableValue("DEST_VERSION");
                if (destVersion != null) {
                    for (String strHost : this.m_nodeList) {
                        currVersion = VerificationUtil.getCRSReleaseVersion(crsHomeV, strHost);
                        if (VerificationUtil.compareVersions(currVersion, destVersion, ".") != 0) continue;
                        throw new StageInitException(s_gMsgBundle.getMessage("0601", true, (Object[])new String[]{currVersion}));
                    }
                }
                this.m_oraInv = VerificationUtil.getOraInventoryGroup();
                this.m_release = "12.1";
                if (destVersion != null && (versionTokens = destVersion.split("\\.")).length > 1) {
                    this.m_release = versionTokens[0] + "." + versionTokens[1];
                }
                if (this.m_osdba == null) {
                    this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                }
                if (this.m_oraInv == null) {
                    this.m_oraInv = VerificationUtil.getOraInventoryGroup();
                }
                if (this.m_asmgrp == null && this.m_existingCRSHomeVersion != null && !Version.isPre112((Version)this.m_existingCRSHomeVersion)) {
                    try {
                        this.m_asmgrp = VerificationUtil.getASMAdminGroup();
                    }
                    catch (CVUException e) {
                        Trace.out((int)5, (String)"Caught exception %s : %s while discovering ASM admin group: ", (Object[])new Object[]{e.getClass(), e.getMessage()});
                        this.m_asmgrp = VerificationUtil.getDefaultAsmGroup();
                    }
                }
            } else {
                if (this.m_osdba == null) {
                    this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                }
                if (this.m_oraInv == null) {
                    this.m_oraInv = VerificationUtil.getDefaultOraInvGroup();
                }
                if (this.m_asmgrp == null) {
                    this.m_asmgrp = VerificationUtil.getDefaultAsmGroup();
                }
                this.m_release = VerificationUtil.getRequestedRelease();
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                if (this.m_asmDev == null) {
                    String version = this.m_release;
                    if (version == null) {
                        version = "12.1.0.1.0";
                    }
                    this.m_asmDev = VerificationUtil.getDefaultDiscoveryDevice(version);
                }
            }
            this.m_param.setOSDBAgroup(this.m_osdba);
            this.m_param.setORAINVgroup(this.m_oraInv);
            this.m_param.setASMADMINgroup(this.m_asmgrp);
            this.m_param.setCRSHome(this.m_existingCRSHomeLocation);
            if (this.m_OCRlocation != null) {
                this.m_param.setOCRLoc(this.m_OCRlocation);
            }
            if (this.m_VdiskLocation != null) {
                this.m_param.setVotingLoc(this.m_VdiskLocation);
            }
            this.m_param.setASMDevice(this.m_asmDev);
            this.m_param.setASMCheck(this.m_ASMCheck);
            this.m_param.setRelease(this.m_release);
        }
    }

    ClusterSvcSetupStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    private void initUpgradeData() throws StageInitException {
        Trace.out((String)"Initializing the update related data");
        if (!VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
            this.m_existingCRSHomeLocation = VerificationUtil.getVariableValue("oracle_install_crs_configuredCRSHome");
        }
        if (VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
            try {
                Assert.assertPath(this.m_existingCRSHomeLocation);
            }
            catch (InvalidPathException e) {
                Trace.out((String)("Caught InvalidPathException : Invalid CRS home path for " + this.m_existingCRSHomeLocation));
                throw new StageInitException(e.getMessage());
            }
        } else {
            String localNode = VerificationUtil.getLocalHostName();
            Result crsHomeResult = new Result(localNode);
            this.m_existingCRSHomeLocation = VerificationUtil.getCRSHome(localNode, crsHomeResult);
            if (!VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
                Trace.out((String)"Failed to retrieved the existing source CRS home location");
                String errMsg = s_msgBundle.getMessage("5301", true);
                throw new StageInitException(errMsg);
            }
            VerificationUtil.setVariableValue("oracle_install_crs_configuredCRSHome", this.m_existingCRSHomeLocation);
        }
        Trace.out((String)("Source CRS home for upgrade is " + this.m_existingCRSHomeLocation));
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        try {
            this.m_existingCRSHomeVersion = VerificationUtil.getCRSActiveVersionObj();
            this.m_localNodeCRSRunning = clustInfo.isCRSRunning(this.m_existingCRSHomeLocation, this.m_existingCRSHomeVersion);
            Trace.out((int)5, (String)"local node CRS running=%b", (Object[])new Object[]{this.m_localNodeCRSRunning});
        }
        catch (InstallException e) {
            Trace.out((int)5, (String)"IGNORED: %s: %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
        }
        for (String node : this.m_nodeList) {
            Result nodeResult = new Result(node);
            String nodeCRSHome = VerificationUtil.getCRSHome(node, nodeResult);
            try {
                if (!clustInfo.isCRSRunning(nodeCRSHome, node, this.m_existingCRSHomeVersion)) continue;
                this.m_nodesWithCRSRunning.add(node);
            }
            catch (InstallException ie) {
                Trace.out((String)("Caught InstallException : for node " + node + ", Ignoring " + ie.getMessage()));
            }
        }
    }

    private void checkSetUpForUpgrade(Version destVersion) throws StageInitException {
        if (Version.isPre12c((Version)destVersion)) {
            if (this.m_isRollingUpgrade && !this.m_localNodeCRSRunning) {
                throw new StageInitException(s_gMsgBundle.getMessage("0710", true));
            }
            if (this.m_localNodeCRSRunning) {
                VerificationUtil.setVariableValue("ISROLLING", "TRUE");
                this.m_isRollingUpgrade = true;
            } else {
                if (this.m_nodesWithCRSRunning.size() > 0) {
                    throw new StageInitException(s_gMsgBundle.getMessage("0713", true, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_nodesWithCRSRunning)}));
                }
                ReportUtil.printWarning(s_gMsgBundle.getMessage("0714", true) + LSEP);
            }
        } else {
            if (!this.m_localNodeCRSRunning) {
                throw new StageInitException(s_gMsgBundle.getMessage("0712", true));
            }
            if (this.m_nodesWithCRSRunning.size() > 1) {
                VerificationUtil.setVariableValue("ISROLLING", "TRUE");
                this.m_isRollingUpgrade = true;
            }
            this.discoverNodeListForRollingUpgrade();
        }
        Trace.out((String)("The upgrade is requested with following data \n Source CRS home " + this.m_existingCRSHomeLocation + "\n The Active version is " + (null != this.m_existingCRSHomeVersion ? this.m_existingCRSHomeVersion.toString() : null) + "\n The destination version for upgrade is " + (null != destVersion ? destVersion.toString() : null) + "\n The local node CRS running status is " + this.m_localNodeCRSRunning + "\n The rolling upgrade flag is set to " + this.m_isRollingUpgrade + "\n The nodes with CRS currently up is (" + this.m_nodesWithCRSRunning.size() + ") : " + VerificationUtil.strList2List(this.m_nodesWithCRSRunning) + "\n The checks will be performed on (" + VerificationUtil.strArr2List(this.m_nodeList)));
        VerificationLogData.log("The upgrade is requested with following data \n Source CRS home " + this.m_existingCRSHomeLocation + "\n The Active version is " + (null != this.m_existingCRSHomeVersion ? this.m_existingCRSHomeVersion.toString() : null) + "\n The destination version for upgrade is " + (null != destVersion ? destVersion.toString() : null) + "\n The local node CRS running status is " + this.m_localNodeCRSRunning + "\n The rolling upgrade flag is set to " + this.m_isRollingUpgrade + "\n The nodes with CRS currently up is (" + this.m_nodesWithCRSRunning.size() + ") : " + VerificationUtil.strList2List(this.m_nodesWithCRSRunning) + "\n The checks will be performed on (" + VerificationUtil.strArr2List(this.m_nodeList) + ")");
    }

    private void discoverNodeListForRollingUpgrade() throws StageInitException {
        try {
            this.m_nodeList = VerificationUtil.getStaticNodelist();
            VerificationUtil.setLocalNodeOperation(false);
        }
        catch (NodelistNotFoundException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(VerificationConstants.LSEP + ReportUtil.ERROR);
            String msg = e.getMessage() + ". " + s_gMsgBundle.getMessage("0711", false);
            throw new StageInitException(msg);
        }
    }

    @Override
    protected boolean checkSetup() {
        boolean retval;
        if (this.m_verificationMode != 1 && !(retval = this.validateEnvironment())) {
            return false;
        }
        super.checkSetup();
        String[] validNodesPreCRSchk = this.getValidNodeList();
        if (validNodesPreCRSchk == null || validNodesPreCRSchk.length == 0) {
            return false;
        }
        if (this.m_verificationMode == 1) {
            Trace.out((String)"==== Skipping CRS home check. n/a for pre check");
            return validNodesPreCRSchk.length == this.getNodeList().length;
        }
        String[] nodesWithCRSinstall = VerificationUtil.getNodesWithCRSInstall(validNodesPreCRSchk, this.m_resultSet);
        this.setValidNodeList(nodesWithCRSinstall);
        if (nodesWithCRSinstall == null) {
            return false;
        }
        return nodesWithCRSinstall.length == this.getNodeList().length;
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> crsInstStageTaskList = null;
            crsInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CRS_INST, this.getValidNodeList(), this.m_param, this);
            if (!this.m_paramMgr.checkArgPatchonly()) {
                this.addToCurrentTaskSet(crsInstStageTaskList.toArray(new Task[0]));
            } else {
                String destinationHome = VerificationUtil.getVariableValue("CRS_HOME");
                ArrayList<Task> patchOnlyTasks = new ArrayList<Task>();
                for (Task task : crsInstStageTaskList) {
                    if (!(task instanceof TaskOraclePatch) || !SeverityType.CRITICAL.equals((Object)task.getSeverity()) || !destinationHome.equals(((TaskOraclePatch)task).getHome())) continue;
                    patchOnlyTasks.add(task);
                }
                this.addToCurrentTaskSet(patchOnlyTasks.toArray(new Task[0]));
            }
        } else {
            List<Task> crsInstStageTaskList = null;
            crsInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_CRS_INST, this.getValidNodeList(), null, this);
            this.addToCurrentTaskSet(crsInstStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }
}

